using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Linq;
using Crestron;
using Crestron.Logos.SplusLibrary;
using Crestron.Logos.SplusObjects;
using Crestron.SimplSharp;

namespace CrestronModule_ADAGIO_AMFM_GUI_PROCESSOR_V1
{
    public class CrestronModuleClass_ADAGIO_AMFM_GUI_PROCESSOR_V1 : SplusObject
    {
        static CCriticalSection g_criticalSection = new CCriticalSection();
        
        
        
        
        
        
        
        
        Crestron.Logos.SplusObjects.DigitalInput AMACTIVE;
        Crestron.Logos.SplusObjects.DigitalInput FMACTIVE;
        Crestron.Logos.SplusObjects.AnalogInput AMFREQIN;
        Crestron.Logos.SplusObjects.AnalogInput FMFREQIN;
        Crestron.Logos.SplusObjects.AnalogInput AMPRESETIN;
        Crestron.Logos.SplusObjects.AnalogInput FMPRESETIN;
        Crestron.Logos.SplusObjects.DigitalInput EUROPEAN;
        Crestron.Logos.SplusObjects.StringInput TRIG;
        Crestron.Logos.SplusObjects.AnalogInput AIPKTDELTA;
        Crestron.Logos.SplusObjects.AnalogInput AIPKTTIME;
        Crestron.Logos.SplusObjects.AnalogInput AISLOWTURNHSEC;
        Crestron.Logos.SplusObjects.AnalogInput AISLOWTURNINCR;
        Crestron.Logos.SplusObjects.AnalogInput AIFASTTURNHSEC;
        Crestron.Logos.SplusObjects.AnalogInput AIFASTTURNINCR;
        InOutArray<Crestron.Logos.SplusObjects.AnalogInput> AIKNOBIN;
        Crestron.Logos.SplusObjects.StringOutput STATION__DOLLAR__;
        Crestron.Logos.SplusObjects.StringOutput PRESET__DOLLAR__;
        InOutArray<Crestron.Logos.SplusObjects.AnalogOutput> AOKNOBOUT;
        int G_SLISLOPE = 0;
        int G_SLIINTERCEPT = 0;
        ushort G_IBUSY = 0;
        ushort MAX_ANALOG = 0;
        ushort MIN_ANALOG = 0;
        ushort STEPSIZE = 0;
        ushort BAND = 0;
        private ushort CHECKVALUE (  SplusExecutionContext __context__, int VALUE ) 
            { 
            ushort NEWVALUE = 0;
            
            int MAXANALOG = 0;
            
            
            __context__.SourceCodeLine = 47;
            MAXANALOG = (int) ( MAX_ANALOG ) ; 
            __context__.SourceCodeLine = 51;
            if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( VALUE > MAXANALOG ))  ) ) 
                {
                __context__.SourceCodeLine = 52;
                NEWVALUE = (ushort) ( MIN_ANALOG ) ; 
                }
            
            else 
                {
                __context__.SourceCodeLine = 53;
                if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( VALUE < MIN_ANALOG ))  ) ) 
                    {
                    __context__.SourceCodeLine = 54;
                    NEWVALUE = (ushort) ( MAX_ANALOG ) ; 
                    }
                
                else 
                    {
                    __context__.SourceCodeLine = 56;
                    NEWVALUE = (ushort) ( Functions.LowWord( (uint)( VALUE ) ) ) ; 
                    }
                
                }
            
            __context__.SourceCodeLine = 60;
            return (ushort)( NEWVALUE) ; 
            
            }
            
        private void COMPUTENEWKNOBVALUE (  SplusExecutionContext __context__, short DIRECTION , ushort TIMEDIFFERENCE ) 
            { 
            ushort NEWVAL = 0;
            
            
            __context__.SourceCodeLine = 67;
            if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( TIMEDIFFERENCE <= AIFASTTURNHSEC  .UshortValue ))  ) ) 
                { 
                __context__.SourceCodeLine = 70;
                NEWVAL = (ushort) ( CHECKVALUE( __context__ , (int)( (AIKNOBIN[ BAND ] .IntValue + ((DIRECTION * AIFASTTURNINCR  .IntValue) * STEPSIZE)) ) ) ) ; 
                __context__.SourceCodeLine = 71;
                
                } 
            
            else 
                {
                __context__.SourceCodeLine = 75;
                if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( (Functions.TestForTrue ( Functions.BoolToInt ( TIMEDIFFERENCE > AIFASTTURNHSEC  .UshortValue ) ) && Functions.TestForTrue ( Functions.BoolToInt ( TIMEDIFFERENCE < AISLOWTURNHSEC  .UshortValue ) )) ))  ) ) 
                    { 
                    __context__.SourceCodeLine = 77;
                    NEWVAL = (ushort) ( CHECKVALUE( __context__ , (int)( (AIKNOBIN[ BAND ] .IntValue + ((DIRECTION * ((G_SLISLOPE * TIMEDIFFERENCE) + G_SLIINTERCEPT)) * STEPSIZE)) ) ) ) ; 
                    __context__.SourceCodeLine = 79;
                    
                    } 
                
                else 
                    { 
                    __context__.SourceCodeLine = 85;
                    NEWVAL = (ushort) ( CHECKVALUE( __context__ , (int)( (AIKNOBIN[ BAND ] .IntValue + ((DIRECTION * AISLOWTURNINCR  .IntValue) * STEPSIZE)) ) ) ) ; 
                    __context__.SourceCodeLine = 87;
                    
                    } 
                
                }
            
            __context__.SourceCodeLine = 91;
            if ( Functions.TestForTrue  ( ( Functions.BoolToInt (NEWVAL != AOKNOBOUT[ BAND ] .Value))  ) ) 
                {
                __context__.SourceCodeLine = 92;
                AOKNOBOUT [ BAND]  .Value = (ushort) ( NEWVAL ) ; 
                }
            
            
            }
            
        private void EVALUATE (  SplusExecutionContext __context__ ) 
            { 
            
            __context__.SourceCodeLine = 97;
            if ( Functions.TestForTrue  ( ( Functions.BoolToInt (AMACTIVE  .Value == 1))  ) ) 
                { 
                __context__.SourceCodeLine = 99;
                BAND = (ushort) ( 1 ) ; 
                __context__.SourceCodeLine = 100;
                if ( Functions.TestForTrue  ( ( Functions.BoolToInt (EUROPEAN  .Value == 1))  ) ) 
                    { 
                    __context__.SourceCodeLine = 102;
                    STEPSIZE = (ushort) ( 9 ) ; 
                    __context__.SourceCodeLine = 103;
                    MAX_ANALOG = (ushort) ( 1710 ) ; 
                    __context__.SourceCodeLine = 104;
                    MIN_ANALOG = (ushort) ( 531 ) ; 
                    } 
                
                else 
                    { 
                    __context__.SourceCodeLine = 108;
                    STEPSIZE = (ushort) ( 10 ) ; 
                    __context__.SourceCodeLine = 109;
                    MAX_ANALOG = (ushort) ( 1710 ) ; 
                    __context__.SourceCodeLine = 110;
                    MIN_ANALOG = (ushort) ( 530 ) ; 
                    } 
                
                } 
            
            else 
                { 
                __context__.SourceCodeLine = 115;
                BAND = (ushort) ( 2 ) ; 
                __context__.SourceCodeLine = 116;
                if ( Functions.TestForTrue  ( ( Functions.BoolToInt (EUROPEAN  .Value == 1))  ) ) 
                    { 
                    __context__.SourceCodeLine = 118;
                    STEPSIZE = (ushort) ( 5 ) ; 
                    __context__.SourceCodeLine = 119;
                    MAX_ANALOG = (ushort) ( 10800 ) ; 
                    __context__.SourceCodeLine = 120;
                    MIN_ANALOG = (ushort) ( 8750 ) ; 
                    } 
                
                else 
                    { 
                    __context__.SourceCodeLine = 124;
                    STEPSIZE = (ushort) ( 10 ) ; 
                    __context__.SourceCodeLine = 125;
                    MAX_ANALOG = (ushort) ( 10800 ) ; 
                    __context__.SourceCodeLine = 126;
                    MIN_ANALOG = (ushort) ( 8800 ) ; 
                    } 
                
                } 
            
            
            }
            
        private void BUILDAM (  SplusExecutionContext __context__ ) 
            { 
            
            __context__.SourceCodeLine = 133;
            if ( Functions.TestForTrue  ( ( AMFREQIN  .UshortValue)  ) ) 
                {
                __context__.SourceCodeLine = 134;
                MakeString ( STATION__DOLLAR__ , "{0:d} AM", (short)AMFREQIN  .UshortValue) ; 
                }
            
            __context__.SourceCodeLine = 135;
            MakeString ( PRESET__DOLLAR__ , "{0:d} AM", (short)AMPRESETIN  .UshortValue) ; 
            
            }
            
        private void BUILDFM (  SplusExecutionContext __context__ ) 
            { 
            
            __context__.SourceCodeLine = 140;
            if ( Functions.TestForTrue  ( ( FMFREQIN  .UshortValue)  ) ) 
                {
                __context__.SourceCodeLine = 141;
                MakeString ( STATION__DOLLAR__ , "{0:d}.{1:d2} FM", (short)(FMFREQIN  .UshortValue / 100), (short)Mod( FMFREQIN  .UshortValue , 100 )) ; 
                }
            
            __context__.SourceCodeLine = 142;
            MakeString ( PRESET__DOLLAR__ , "{0:d}.{1:d2} FM", (short)(FMPRESETIN  .UshortValue / 100), (short)Mod( FMPRESETIN  .UshortValue , 100 )) ; 
            
            }
            
        private void CALCULATESLOPE (  SplusExecutionContext __context__ ) 
            { 
            int RISE = 0;
            
            int RUN = 0;
            
            ushort NFLAG = 0;
            
            
            __context__.SourceCodeLine = 151;
            RISE = (int) ( (AIFASTTURNINCR  .IntValue - AISLOWTURNINCR  .IntValue) ) ; 
            __context__.SourceCodeLine = 152;
            RUN = (int) ( (AIFASTTURNHSEC  .IntValue - AISLOWTURNHSEC  .IntValue) ) ; 
            __context__.SourceCodeLine = 154;
            NFLAG = (ushort) ( 0 ) ; 
            __context__.SourceCodeLine = 155;
            if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( RISE < 0 ))  ) ) 
                { 
                __context__.SourceCodeLine = 157;
                RISE = (int) ( Functions.ToSignedLongInteger( -( RISE ) ) ) ; 
                __context__.SourceCodeLine = 158;
                NFLAG = (ushort) ( 1 ) ; 
                } 
            
            __context__.SourceCodeLine = 161;
            if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( RUN < 0 ))  ) ) 
                { 
                __context__.SourceCodeLine = 163;
                RUN = (int) ( Functions.ToSignedLongInteger( -( RUN ) ) ) ; 
                __context__.SourceCodeLine = 164;
                if ( Functions.TestForTrue  ( ( Functions.BoolToInt (NFLAG == 1))  ) ) 
                    {
                    __context__.SourceCodeLine = 165;
                    NFLAG = (ushort) ( 0 ) ; 
                    }
                
                else 
                    {
                    __context__.SourceCodeLine = 167;
                    NFLAG = (ushort) ( 1 ) ; 
                    }
                
                } 
            
            __context__.SourceCodeLine = 170;
            G_SLISLOPE = (int) ( (RISE / RUN) ) ; 
            __context__.SourceCodeLine = 171;
            if ( Functions.TestForTrue  ( ( Functions.BoolToInt (NFLAG == 1))  ) ) 
                {
                __context__.SourceCodeLine = 172;
                G_SLISLOPE = (int) ( Functions.ToSignedLongInteger( -( G_SLISLOPE ) ) ) ; 
                }
            
            __context__.SourceCodeLine = 176;
            G_SLIINTERCEPT = (int) ( (AISLOWTURNINCR  .IntValue - (G_SLISLOPE * AISLOWTURNHSEC  .IntValue)) ) ; 
            __context__.SourceCodeLine = 178;
            
            
            }
            
        object TRIG_OnChange_0 ( Object __EventInfo__ )
        
            { 
            Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
            try
            {
                SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
                CrestronString TEMP;
                TEMP  = new CrestronString( Crestron.Logos.SplusObjects.CrestronStringEncoding.eEncodingASCII, 1, this );
                
                
                __context__.SourceCodeLine = 189;
                if ( Functions.TestForTrue  ( ( Functions.BoolToInt (G_IBUSY == 0))  ) ) 
                    { 
                    __context__.SourceCodeLine = 191;
                    G_IBUSY = (ushort) ( 1 ) ; 
                    __context__.SourceCodeLine = 192;
                    while ( Functions.TestForTrue  ( ( 1)  ) ) 
                        { 
                        __context__.SourceCodeLine = 194;
                        TEMP  .UpdateValue ( Functions.Gather ( "*" , TRIG )  ) ; 
                        __context__.SourceCodeLine = 203;
                        COMPUTENEWKNOBVALUE (  __context__ , (short)( AIPKTDELTA  .ShortValue ), (ushort)( AIPKTTIME  .UshortValue )) ; 
                        __context__.SourceCodeLine = 192;
                        } 
                    
                    __context__.SourceCodeLine = 209;
                    G_IBUSY = (ushort) ( 0 ) ; 
                    } 
                
                
                
            }
            catch(Exception e) { ObjectCatchHandler(e); }
            finally { ObjectFinallyHandler( __SignalEventArg__ ); }
            return this;
            
        }
        
    object AIFASTTURNINCR_OnChange_1 ( Object __EventInfo__ )
    
        { 
        Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
        try
        {
            SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
            
            __context__.SourceCodeLine = 215;
            CALCULATESLOPE (  __context__  ) ; 
            
            
        }
        catch(Exception e) { ObjectCatchHandler(e); }
        finally { ObjectFinallyHandler( __SignalEventArg__ ); }
        return this;
        
    }
    
object EUROPEAN_OnChange_2 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 220;
        EVALUATE (  __context__  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object AMACTIVE_OnPush_3 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 225;
        BUILDAM (  __context__  ) ; 
        __context__.SourceCodeLine = 226;
        EVALUATE (  __context__  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object FMACTIVE_OnPush_4 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 231;
        BUILDFM (  __context__  ) ; 
        __context__.SourceCodeLine = 232;
        EVALUATE (  __context__  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object AMFREQIN_OnChange_5 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 237;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt (AMACTIVE  .Value == 1))  ) ) 
            {
            __context__.SourceCodeLine = 238;
            BUILDAM (  __context__  ) ; 
            }
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object AMPRESETIN_OnChange_6 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 243;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt (AMACTIVE  .Value == 1))  ) ) 
            {
            __context__.SourceCodeLine = 244;
            BUILDAM (  __context__  ) ; 
            }
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object FMPRESETIN_OnChange_7 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 249;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt (FMACTIVE  .Value == 1))  ) ) 
            {
            __context__.SourceCodeLine = 250;
            BUILDFM (  __context__  ) ; 
            }
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object FMFREQIN_OnChange_8 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 255;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt (FMACTIVE  .Value == 1))  ) ) 
            {
            __context__.SourceCodeLine = 256;
            BUILDFM (  __context__  ) ; 
            }
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

public override object FunctionMain (  object __obj__ ) 
    { 
    try
    {
        SplusExecutionContext __context__ = SplusFunctionMainStartCode();
        
        __context__.SourceCodeLine = 261;
        G_IBUSY = (ushort) ( 0 ) ; 
        __context__.SourceCodeLine = 263;
        WaitForInitializationComplete ( ) ; 
        __context__.SourceCodeLine = 265;
        EVALUATE (  __context__  ) ; 
        __context__.SourceCodeLine = 267;
        CALCULATESLOPE (  __context__  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler(); }
    return __obj__;
    }
    

public override void LogosSplusInitialize()
{
    _SplusNVRAM = new SplusNVRAM( this );
    
    AMACTIVE = new Crestron.Logos.SplusObjects.DigitalInput( AMACTIVE__DigitalInput__, this );
    m_DigitalInputList.Add( AMACTIVE__DigitalInput__, AMACTIVE );
    
    FMACTIVE = new Crestron.Logos.SplusObjects.DigitalInput( FMACTIVE__DigitalInput__, this );
    m_DigitalInputList.Add( FMACTIVE__DigitalInput__, FMACTIVE );
    
    EUROPEAN = new Crestron.Logos.SplusObjects.DigitalInput( EUROPEAN__DigitalInput__, this );
    m_DigitalInputList.Add( EUROPEAN__DigitalInput__, EUROPEAN );
    
    AMFREQIN = new Crestron.Logos.SplusObjects.AnalogInput( AMFREQIN__AnalogSerialInput__, this );
    m_AnalogInputList.Add( AMFREQIN__AnalogSerialInput__, AMFREQIN );
    
    FMFREQIN = new Crestron.Logos.SplusObjects.AnalogInput( FMFREQIN__AnalogSerialInput__, this );
    m_AnalogInputList.Add( FMFREQIN__AnalogSerialInput__, FMFREQIN );
    
    AMPRESETIN = new Crestron.Logos.SplusObjects.AnalogInput( AMPRESETIN__AnalogSerialInput__, this );
    m_AnalogInputList.Add( AMPRESETIN__AnalogSerialInput__, AMPRESETIN );
    
    FMPRESETIN = new Crestron.Logos.SplusObjects.AnalogInput( FMPRESETIN__AnalogSerialInput__, this );
    m_AnalogInputList.Add( FMPRESETIN__AnalogSerialInput__, FMPRESETIN );
    
    AIPKTDELTA = new Crestron.Logos.SplusObjects.AnalogInput( AIPKTDELTA__AnalogSerialInput__, this );
    m_AnalogInputList.Add( AIPKTDELTA__AnalogSerialInput__, AIPKTDELTA );
    
    AIPKTTIME = new Crestron.Logos.SplusObjects.AnalogInput( AIPKTTIME__AnalogSerialInput__, this );
    m_AnalogInputList.Add( AIPKTTIME__AnalogSerialInput__, AIPKTTIME );
    
    AISLOWTURNHSEC = new Crestron.Logos.SplusObjects.AnalogInput( AISLOWTURNHSEC__AnalogSerialInput__, this );
    m_AnalogInputList.Add( AISLOWTURNHSEC__AnalogSerialInput__, AISLOWTURNHSEC );
    
    AISLOWTURNINCR = new Crestron.Logos.SplusObjects.AnalogInput( AISLOWTURNINCR__AnalogSerialInput__, this );
    m_AnalogInputList.Add( AISLOWTURNINCR__AnalogSerialInput__, AISLOWTURNINCR );
    
    AIFASTTURNHSEC = new Crestron.Logos.SplusObjects.AnalogInput( AIFASTTURNHSEC__AnalogSerialInput__, this );
    m_AnalogInputList.Add( AIFASTTURNHSEC__AnalogSerialInput__, AIFASTTURNHSEC );
    
    AIFASTTURNINCR = new Crestron.Logos.SplusObjects.AnalogInput( AIFASTTURNINCR__AnalogSerialInput__, this );
    m_AnalogInputList.Add( AIFASTTURNINCR__AnalogSerialInput__, AIFASTTURNINCR );
    
    AIKNOBIN = new InOutArray<AnalogInput>( 2, this );
    for( uint i = 0; i < 2; i++ )
    {
        AIKNOBIN[i+1] = new Crestron.Logos.SplusObjects.AnalogInput( AIKNOBIN__AnalogSerialInput__ + i, AIKNOBIN__AnalogSerialInput__, this );
        m_AnalogInputList.Add( AIKNOBIN__AnalogSerialInput__ + i, AIKNOBIN[i+1] );
    }
    
    AOKNOBOUT = new InOutArray<AnalogOutput>( 2, this );
    for( uint i = 0; i < 2; i++ )
    {
        AOKNOBOUT[i+1] = new Crestron.Logos.SplusObjects.AnalogOutput( AOKNOBOUT__AnalogSerialOutput__ + i, this );
        m_AnalogOutputList.Add( AOKNOBOUT__AnalogSerialOutput__ + i, AOKNOBOUT[i+1] );
    }
    
    TRIG = new Crestron.Logos.SplusObjects.StringInput( TRIG__AnalogSerialInput__, 1, this );
    m_StringInputList.Add( TRIG__AnalogSerialInput__, TRIG );
    
    STATION__DOLLAR__ = new Crestron.Logos.SplusObjects.StringOutput( STATION__DOLLAR____AnalogSerialOutput__, this );
    m_StringOutputList.Add( STATION__DOLLAR____AnalogSerialOutput__, STATION__DOLLAR__ );
    
    PRESET__DOLLAR__ = new Crestron.Logos.SplusObjects.StringOutput( PRESET__DOLLAR____AnalogSerialOutput__, this );
    m_StringOutputList.Add( PRESET__DOLLAR____AnalogSerialOutput__, PRESET__DOLLAR__ );
    
    
    TRIG.OnSerialChange.Add( new InputChangeHandlerWrapper( TRIG_OnChange_0, false ) );
    AIFASTTURNINCR.OnAnalogChange.Add( new InputChangeHandlerWrapper( AIFASTTURNINCR_OnChange_1, false ) );
    EUROPEAN.OnDigitalChange.Add( new InputChangeHandlerWrapper( EUROPEAN_OnChange_2, false ) );
    AMACTIVE.OnDigitalPush.Add( new InputChangeHandlerWrapper( AMACTIVE_OnPush_3, false ) );
    FMACTIVE.OnDigitalPush.Add( new InputChangeHandlerWrapper( FMACTIVE_OnPush_4, false ) );
    AMFREQIN.OnAnalogChange.Add( new InputChangeHandlerWrapper( AMFREQIN_OnChange_5, false ) );
    AMPRESETIN.OnAnalogChange.Add( new InputChangeHandlerWrapper( AMPRESETIN_OnChange_6, false ) );
    FMPRESETIN.OnAnalogChange.Add( new InputChangeHandlerWrapper( FMPRESETIN_OnChange_7, false ) );
    FMFREQIN.OnAnalogChange.Add( new InputChangeHandlerWrapper( FMFREQIN_OnChange_8, false ) );
    
    _SplusNVRAM.PopulateCustomAttributeList( true );
    
    NVRAM = _SplusNVRAM;
    
}

public override void LogosSimplSharpInitialize()
{
    
    
}

public CrestronModuleClass_ADAGIO_AMFM_GUI_PROCESSOR_V1 ( string InstanceName, string ReferenceID, Crestron.Logos.SplusObjects.CrestronStringEncoding nEncodingType ) : base( InstanceName, ReferenceID, nEncodingType ) {}




const uint AMACTIVE__DigitalInput__ = 0;
const uint FMACTIVE__DigitalInput__ = 1;
const uint AMFREQIN__AnalogSerialInput__ = 0;
const uint FMFREQIN__AnalogSerialInput__ = 1;
const uint AMPRESETIN__AnalogSerialInput__ = 2;
const uint FMPRESETIN__AnalogSerialInput__ = 3;
const uint EUROPEAN__DigitalInput__ = 2;
const uint TRIG__AnalogSerialInput__ = 4;
const uint AIPKTDELTA__AnalogSerialInput__ = 5;
const uint AIPKTTIME__AnalogSerialInput__ = 6;
const uint AISLOWTURNHSEC__AnalogSerialInput__ = 7;
const uint AISLOWTURNINCR__AnalogSerialInput__ = 8;
const uint AIFASTTURNHSEC__AnalogSerialInput__ = 9;
const uint AIFASTTURNINCR__AnalogSerialInput__ = 10;
const uint AIKNOBIN__AnalogSerialInput__ = 11;
const uint STATION__DOLLAR____AnalogSerialOutput__ = 0;
const uint PRESET__DOLLAR____AnalogSerialOutput__ = 1;
const uint AOKNOBOUT__AnalogSerialOutput__ = 2;

[SplusStructAttribute(-1, true, false)]
public class SplusNVRAM : SplusStructureBase
{

    public SplusNVRAM( SplusObject __caller__ ) : base( __caller__ ) {}
    
    
}

SplusNVRAM _SplusNVRAM = null;

public class __CEvent__ : CEvent
{
    public __CEvent__() {}
    public void Close() { base.Close(); }
    public int Reset() { return base.Reset() ? 1 : 0; }
    public int Set() { return base.Set() ? 1 : 0; }
    public int Wait( int timeOutInMs ) { return base.Wait( timeOutInMs ) ? 1 : 0; }
}
public class __CMutex__ : CMutex
{
    public __CMutex__() {}
    public void Close() { base.Close(); }
    public void ReleaseMutex() { base.ReleaseMutex(); }
    public int WaitForMutex() { return base.WaitForMutex() ? 1 : 0; }
}
 public int IsNull( object obj ){ return (obj == null) ? 1 : 0; }
}


}
